dofile(LockOn_Options.common_script_path.."elements_defs.lua")

UFC_DEFAULT_LEVEL     = 5

SetScale(FOV)

ufc_scale		= 0.55/275
ufc_grid_scale	= 0.50/275
ufc_hdg_scale	= 0.70/275
ufc_hdg_displ	= (3448 * ufc_hdg_scale / 480) * GetScale()

--- Colors Definitions ---

UFC_GREEN	= {0, 255, 100, 255}

---- Fonts Definition ----
local resources_path_f = LockOn_Options.script_path.."Resources/Fonts/"

UFC_default_font_size    = {0.010, 0.010}
RADIO_default_font_size  = {0.012, 0.012}

UFC_xsize = 146
UFC_ysize = 146

local ufc_font_desc = {
	texture		= resources_path_f.."font_UFC_AV8B.dds",
	size		= {7, 7},
	resolution	= {1024, 1024},
	default		= {UFC_xsize, UFC_ysize},
	chars		= {
		[1]		= {32,	UFC_xsize, UFC_ysize},	-- SPACE
		[2]		= {48,	UFC_xsize, UFC_ysize},	-- 0
		[3]		= {49,	UFC_xsize, UFC_ysize},	-- 1
		[4]		= {50,	UFC_xsize, UFC_ysize},	-- 2
		[5]		= {51,	UFC_xsize, UFC_ysize},	-- 3
		[6]		= {52,	UFC_xsize, UFC_ysize},	-- 4
		[7]		= {53,	UFC_xsize, UFC_ysize},	-- 5
		[8]		= {54,	UFC_xsize, UFC_ysize},	-- 6
		[9]		= {55,	UFC_xsize, UFC_ysize},	-- 7
		[10]	= {56,	UFC_xsize, UFC_ysize},	-- 8
		[11]	= {57,	UFC_xsize, UFC_ysize},	-- 9
		[12]	= {126,	UFC_xsize, UFC_ysize},	-- ~
		[13]	= {65,	UFC_xsize, UFC_ysize},	-- A
		[14]	= {66,	UFC_xsize, UFC_ysize},	-- B
		[15]	= {67,	UFC_xsize, UFC_ysize},	-- C
		[16]	= {68,	UFC_xsize, UFC_ysize},	-- D
		[17]	= {69,	UFC_xsize, UFC_ysize},	-- E
		[18]	= {70,	UFC_xsize, UFC_ysize},	-- F
		[19]	= {71,	UFC_xsize, UFC_ysize},	-- G
		[20]	= {72,	UFC_xsize, UFC_ysize},	-- H
		[21]	= {73,	UFC_xsize, UFC_ysize},	-- I
		[22]	= {74,	UFC_xsize, UFC_ysize},	-- J
		[23]	= {75,	UFC_xsize, UFC_ysize},	-- K
		[24]	= {76,	UFC_xsize, UFC_ysize},	-- L
		[25]	= {77,	UFC_xsize, UFC_ysize},	-- M
		[26]	= {78,	UFC_xsize, UFC_ysize},	-- N
		[27]	= {79,	UFC_xsize, UFC_ysize},	-- O
		[28]	= {80,	UFC_xsize, UFC_ysize},	-- P
		[29]	= {81,	UFC_xsize, UFC_ysize},	-- Q
		[30]	= {82,	UFC_xsize, UFC_ysize},	-- R
		[31]	= {83,	UFC_xsize, UFC_ysize},	-- S
		[32]	= {84,	UFC_xsize, UFC_ysize},	-- T
		[33]	= {85,	UFC_xsize, UFC_ysize},	-- U
		[34]	= {86,	UFC_xsize, UFC_ysize},	-- V
		[35]	= {87,	UFC_xsize, UFC_ysize},	-- W
		[36]	= {88,	UFC_xsize, UFC_ysize},	-- X
		[37]	= {89,	UFC_xsize, UFC_ysize},	-- Y
		[38]	= {90,	UFC_xsize, UFC_ysize},	-- Z
		[39]	= {47,	UFC_xsize, UFC_ysize},	-- /
		[40]	= {95,	UFC_xsize, UFC_ysize},	-- _ 
		[41]	= {58,	UFC_xsize, UFC_ysize},	-- :
		[42]	= {42,	UFC_xsize, UFC_ysize},	-- *
		[43]	= {44,	UFC_xsize, UFC_ysize},	-- ,
		[44]	= {64,	UFC_xsize, UFC_ysize},	-- @
		[45]	= {46,	UFC_xsize, UFC_ysize},	-- .
		[46]	= {39,	UFC_xsize, UFC_ysize},	-- '
		[47]	= {45,	UFC_xsize, UFC_ysize},	-- -
		[48]	= {33,	UFC_xsize, UFC_ysize},	-- !
		[49]	= {124,	UFC_xsize, UFC_ysize},	-- |
	}
}

ufc_font_base	= MakeFont(ufc_font_desc, UFC_GREEN,	"ufc_font_base")


----- UFC Functions -----
function Add_UFC_Element(object)
	object.use_mipfilter      = true
	object.h_clip_relation    = h_clip_relations.COMPARE
	object.level			  = UFC_DEFAULT_LEVEL
	object.additive_alpha     = true --additive blending
	object.collimated 		  = false
	Add(object)
end
